package cn.ipokerface.netty.client.connection;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

/**
 * Created by       PokerFace
 * Create Date      2020-03-13.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConnectionInboundHandlerAdapter extends ChannelInboundHandlerAdapter {


    private ConnectionManager connectionManager;


    public ConnectionInboundHandlerAdapter(ConnectionManager connectionManager)
    {
        this.connectionManager = connectionManager;
    }


    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {

        if (connectionManager != null)
        {
            connectionManager.connected(ctx);
        }

        super.channelActive(ctx);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {

        if (connectionManager != null)
        {
            connectionManager.disconnected(ctx);
        }
        super.channelInactive(ctx);
    }
}
