package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.client.NettyClient;
import cn.ipokerface.netty.message.Request;
import cn.ipokerface.netty.message.Response;
import cn.ipokerface.netty.request.TransactionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by       PokerFace
 * Create Date      2020-03-13.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConnectionIdleManager extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionIdleManager.class);

    public static final long default_idle = 20000l;

    private NettyClient context;

    private Request message;
    private long idle = 20000;

    private volatile boolean running = true;


    public ConnectionIdleManager(NettyClient context)
    {
        this.context = context;
        setName("ConnectionIdleManager");
        setDaemon(true);
    }


    @Override
    public void run() {

        while (running)
        {
            sendHeartbeatRequest();

            try
            {
                Thread.sleep(idle);
            }catch (InterruptedException e)
            {
                logger.error("ConnectionIdleManager interrupted with error: " + e.getMessage());
            }
        }
    }

    public void setIdleMessage(Request request) {
        this.message = request;
    }


    public void setIdleMessage(Request request, long idle)
    {
        this.message = request;
        this.idle = idle;
    }


    public void sendHeartbeatRequest()
    {

        if (message == null)
        {
            logger.debug(" message is empty  cancel idle checker");
            return;
        }
        context.request(message, new TransactionListener()
        {
            @Override
            public void onResponse(Response response)
            {
                logger.debug("Keep connection with server by heart beat success!");
            }
            @Override
            public void onFailed()
            {
                logger.error("Keep connection request to  server failed!!!");
            }
            @Override
            public void onTimeout()
            {
                logger.error("Keep connection request to server timeout!!!");
            }
        });

    }

}
