package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.NettyContext;
import io.netty.channel.ChannelHandlerContext;

/**
 * Created by       PokerFace
 * Create Date      2020-08-12.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ClientConnection extends cn.ipokerface.netty.connection.Connection {

    protected String host;
    protected int port;
    protected ConnectionState state;


    public ClientConnection(NettyContext context) {
        super(context);
        state = ConnectionState.DISCONNECT;
    }

    /**
     * please call this when connected
     *
     * @param context context
     */
    public void setChannelHandlerContext(ChannelHandlerContext context) {
        super.channel = context.channel();
    }


    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public ConnectionState getState() {
        return state;
    }

    public boolean isConnected()
    {
        return state.equals(ConnectionState.CONNECTED);
    }


    public enum ConnectionState
    {
        // 未连接
        DISCONNECT,
        // 连接中
        CONNECTING,
        // 已连接
        CONNECTED,
        ;
    }

}
