package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.NettyContext;
import cn.ipokerface.netty.client.NettyClient;
import io.netty.channel.ChannelHandlerContext;

/**
 * Created by       PokerFace
 * Create Date      2020-08-12.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConnectionManager {

    private NettyClient context;
    private Connection connection;
    private ConnectionListener connectionListener;


    public ConnectionManager(NettyClient context)
    {
        this.context = context;
        this.connection = new Connection(context);
    }


    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public Connection getConnection() {
        return connection;
    }

    public void connected(ChannelHandlerContext context){
        connection.setChannelHandlerContext(context);
        connection.setState(Connection.ConnectionState.CONNECTED);
        if (connectionListener != null)
        {
            connectionListener.connected(this.connection);
        }
    }


    public void disconnected(ChannelHandlerContext ctx)
    {
        connection.setState(Connection.ConnectionState.DISCONNECTED);
        if (connectionListener != null)
        {
            connectionListener.disconnected(this.connection);
        }
    }


    public void connectFailed()
    {
        connection.setState(Connection.ConnectionState.PREPARE);
        if (connectionListener != null)
        {
            connectionListener.failed(this.connection);
        }
    }


}
