package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.client.NettyClient;
import cn.ipokerface.netty.message.Request;
import cn.ipokerface.netty.message.Response;
import cn.ipokerface.netty.request.ResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by       PokerFace
 * Create Date      2020-03-13.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConnectionIdleManager extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionIdleManager.class);

    public static final long default_idle = 20000l;

    private NettyClient content;

    private Request message;
    private long idle;

    private boolean running = true;


    public ConnectionIdleManager(NettyClient context, Request message)
    {
        this.content = context;
        this.message = message;
        setName("ConnectionIdleManager");
        setDaemon(true);
    }


    @Override
    public void run() {

        while (running)
        {
            sendHeartbeatRequest();

            try
            {
                Thread.sleep(20);
            }catch (InterruptedException e)
            {
                logger.error("ConnectionIdleManager interrupted with error: " + e.getMessage());
            }
        }
    }


    public void setHeartMessage(Request request, long idle)
    {
        this.message = request;
        this.idle = idle;
    }


    public void sendHeartbeatRequest()
    {

        if (message == null)
        {
            logger.debug(" message is empty  cancel idle checker");
            return;
        }
        content.request(message, new ResponseListener()
        {
            @Override
            public void onResponse(Response response)
            {
                logger.debug("Keep connection with server by heart beat success!");
            }
            @Override
            public void onFailed()
            {
                logger.error("Keep connection request to  server failed!!!");
            }
            @Override
            public void onTimeout()
            {
                logger.error("Keep connection request to server timeout!!!");
            }
        });

    }

}
