package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.NettyContext;
import io.netty.channel.ChannelHandlerContext;

/**
 * Created by       PokerFace
 * Create Date      2020-08-12.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class Connection extends cn.ipokerface.netty.connection.Connection {

    private String server;

    private int port;

    private ConnectionState state;


    public Connection(NettyContext context) {
        super(context);
        state = ConnectionState.PREPARE;
    }

    /**
     * please call this when connected
     *
     * @param context
     */
    public void setChannelHandlerContext(ChannelHandlerContext context)
    {
        super.channel = context.channel();

    }


    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    public boolean isConnected()
    {
        return state.equals(ConnectionState.CONNECTED);
    }


    public enum ConnectionState
    {
        CONNECTED,PREPARE,DISCONNECTED;
    }

}
