package cn.ipokerface.mybatis;

/**
 * Created by       PokerFace
 * Create Date      2021/4/7.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface AbstractMapper <P,E>{

    /**
     *  insert record into db
     *
     * @param record record
     * @return count
     */
    int insert(E record);


    /**
     *  insert record which property is not null
     *
     * @param record record
     * @return  count
     */
    int insertSelective(E record);

    /**
     * delete record by primary key
     *
     * @param id primary key
     * @return count
     */
    int deleteByPrimaryKey(P id);

    /**
     * select record by primary key
     *
     * @param id primary key
     * @return record
     */
    E selectByPrimaryKey(P id);

    /**
     * update record by primary key
     *
     * @param record record
     * @return count
     */
    int updateByPrimaryKey(E record);

    /**
     *  update record by primary key which record is not null
     *
     * @param record record
     * @return count
     */
    int updateByPrimaryKeySelective(E record);




}
