/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.mybatis.query;

import cn.ipokerface.mybatis.query.Condition;
import cn.ipokerface.mybatis.query.OrderBy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Where {
    private boolean distinct = false;
    private List<ConditionWrapper> conditions;
    private OrderBy orderBy;
    private String end;
    private Limit limit;

    public static Builder where() {
        return new Builder();
    }

    public List<ConditionWrapper> getConditions() {
        return this.conditions;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public String getEnd() {
        return this.end;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public static class Builder {
        private List<ConditionWrapper> conditions = new ArrayList<ConditionWrapper>();
        private OrderBy orderBy;
        private String end;
        private Limit limit;
        private boolean distinct = false;

        public Where build() {
            Where where = new Where();
            where.conditions = this.conditions;
            where.orderBy = this.orderBy;
            where.end = this.end;
            where.limit = this.limit;
            where.distinct = this.distinct;
            return where;
        }

        public Builder and(Condition condition) {
            if (condition == null) {
                throw new IllegalArgumentException("Condiction Can not be null");
            }
            this.conditions.add(new ConditionWrapper(AndOr.AND, condition));
            return this;
        }

        public Builder or(Condition condition) {
            if (condition == null) {
                throw new IllegalArgumentException("Condiction Can not be null");
            }
            this.conditions.add(new ConditionWrapper(AndOr.OR, condition));
            return this;
        }

        public Builder distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        public Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public Builder limit(int size) {
            return this.limit(0, size);
        }

        public Builder limit(int start, int size) {
            this.limit = new Limit(start, size);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AndOr {
        AND("AND"),
        OR("OR");

        private String value;

        private AndOr(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Limit {
        private int start = 0;
        private int size;

        public Limit(int start, int size) {
            this.start = start;
            this.size = size;
        }

        public Limit(int size) {
            this.size = size;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class ConditionWrapper {
        private AndOr conn;
        private Condition condition;

        private ConditionWrapper(AndOr conn, Condition condition) {
            this.condition = condition;
            this.conn = conn;
        }

        public AndOr getConn() {
            return this.conn;
        }

        public Condition getCondition() {
            return this.condition;
        }
    }
}

