package cn.ipokerface.mybatis.query;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:     ep:
 *                      Where.where().build();
 *                      Where.where().and(EntityProperties.id.eq(value)).build();
 *                      Where.where().orderBy(EntityProperties.id.desc()).build();
 *                      Where.where().limit(20).build();
 *                      Where.where().limit(0,20).build();
 *
 *                      {@link Property#isNull()}
 *                      {@link Property#isNotNull()}
 *                      {@link Property#equal(Object)} }
 *                      ...
 *
 */
public class Where {

    private boolean distinct = false;

    private List<ConditionWrapper> conditions;

    private OrderBy orderBy;

    private String end;

    private Limit limit;

    public static Builder where(){
        return new Builder();
    }


    public List<ConditionWrapper> getConditions() {
        return conditions;
    }

    public OrderBy getOrderBy() {
        return orderBy;
    }

    public String getEnd() {
        return end;
    }

    public Limit getLimit() {
        return limit;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public static class ConditionWrapper{
        private AndOr conn;
        private Condition condition;
        private ConditionWrapper(AndOr conn, Condition condition){
            this.condition = condition;
            this.conn = conn;
        }

        public AndOr getConn() {
            return conn;
        }

        public Condition getCondition() {
            return condition;
        }

    }


    public static class Limit{

        private int start = 0;

        private int size;


        public Limit(int start, int size){
            this.start = start;
            this.size = size;
        }

        public Limit(int size){
            this.size = size;
        }


        public int getStart() {
            return start;
        }

        public int getSize() {
            return size;
        }
    }


    public static enum AndOr{

        AND("AND"),
        OR("OR")
        ;
        private String value;
        private AndOr(String value){
            this.value = value;
        }
        public String getValue(){
            return this.value;
        }
    }

    public static class Builder{
        private List<ConditionWrapper> conditions;
        private OrderBy orderBy;
        private String end;
        private Limit limit;
        private boolean distinct = false;

        public Builder(){
            this.conditions = new ArrayList<ConditionWrapper>();
        }

        public Where build(){
            Where where = new Where();
            where.conditions = this.conditions;
            where.orderBy = this.orderBy;
            where.end = this.end;
            where.limit = this.limit;
            where.distinct = this.distinct;
            return where;
        }


        /**
         *  and #{param} #{then} #{value} ...
         *
         * @param condition
         * @return
         *      Builder
         */
        public Builder and(Condition condition){
            if (condition == null) throw new IllegalArgumentException("Condiction Can not be null");
            this.conditions.add(new ConditionWrapper(AndOr.AND, condition));
            return this;
        }


        /**
         *  or #{param} #{then} #{value} ...
         *
         * @param condition
         * @return
         *      Builder
         */
        public Builder or(Condition condition){
            if (condition == null) throw new IllegalArgumentException("Condiction Can not be null");
            this.conditions.add(new ConditionWrapper(AndOr.OR, condition));
            return this;
        }


        /**
         *  是否distinct
         *
         * @param distinct
         * @return
         *      Builder
         */
        public Builder distinct(boolean distinct){
            this.distinct = distinct;
            return this;
        }


        /**
         *  设置排序条件
         *
         * @param orderBy
         * @return
         *      Builder
         */
        public Builder orderBy(OrderBy orderBy){
            this.orderBy = orderBy;
            return this;
        }

        /**
         *  设置在语句的最后面    可以自定义一些操作
         *
         * @param end
         * @return
         *      Builder
         */
        public Builder end(String end){
            this.end = end;
            return this;
        }


        /**
         * 构造一个分页器    默认为第一页
         *
         * @param size
         * @return
         *      Builder
         */
        public Builder limit(int size){
            return this.limit(0, size);
        }


        /**
         *  构造一个分页器
         *
         * @param start
         *          第一条数据位置
         * @param size
         *          数据条数
         * @return
         *      Builder
         */
        public Builder limit(int start, int size){
            this.limit = new Limit(start, size);
            return this;
        }

    }
}
