package cn.ipokerface.mybatis.query;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public class Property {

    private String name;

    private Class<?> type;

    private String column;

    public Property(String name, Class<?> type, String column) {
        this.name = name;
        this.type = type;
        this.column = column;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getColumn() {
        return column;
    }


    public void setColumn(String column) {
        this.column = column;
    }


    /**
     *  Condition :
     *
     *     ${PROPERTY} IS NULL
     *
     * @return
     *      Condition
     */
    public Condition isNull(){
        return new Condition(this, Then.NULL);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} IS NOT NULL
     *
     * @return
     *      Condition
     */
    public Condition isNotNull(){
        return new Condition(this, Then.NOT_NULL);
    }

    /**
     * Condition
     *
     *      ${PROPERTY} &gt; #{value}
     *
     * @return
     *      Condition
     */
    public Condition greater(Object value){
        return new Condition(this, Then.GREATER, value);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} &gt;= #{value}
     *
     * @return
     *      Condition
     */
    public Condition greaterEqual(Object value){
        return new Condition(this, Then.GREATER_EQUAL, value);
    }

    /**
     * Condition
     *
     *      ${PROPERTY} &lt; #{value}
     *
     * @return
     *      Condition
     */
    public Condition less(Object value){
        return new Condition(this, Then.LESS, value);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} &lt;= #{value}
     *
     * @return
     *      Condition
     */
    public Condition lessEqual(Object value){
        return new Condition(this, Then.LESS_EQUAL, value);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} = #{value}
     *
     * @return
     *      Condition
     */
    public Condition equal(Object value){
        return new Condition(this, Then.EQUAL, value);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} != #{value}
     *
     * @return
     *      Condition
     */
    public Condition notEqual(Object value) {
        return new Condition(this, Then.NOT_EQUAL, value);
    }


    /**
     * Condition
     *
     *      ${PROPERTY} BETWEEN #{value1} AND #{value2}
     *
     * @return
     *      Condition
     */
    public Condition between(Object value1 , Object value2){
        return new Condition(this, Then.BETWEEN, value1, value2);
    }

    /**
     * Condition
     *
     *      ${PROPERTY} IN ( #{value1}, #{value2},...)
     *
     * @return
     *      Condition
     */
    public Condition in(List<Object> list){
        return new Condition(this, Then.IN, list);
    }

    /**
     * Condition
     *
     *      ${PROPERTY} NOT IN ( #{value1}, #{value2},...)
     *
     * @return
     *      Condition
     */
    public Condition notIn(List<Object> list){
        return new Condition(this, Then.NOT_IN, list);
    }

    /**
     * Condition
     *
     *      ${PROPERTY} LIKE '%value'
     *
     * @return
     *      Condition
     */
    public Condition likeLeft(Object value){
        return new Condition(this, Then.LIKE, "%"+value.toString());
    }

    /**
     * Condition
     *
     *      ${PROPERTY} LIKE 'value%'
     *
     * @return
     *      Condition
     */
    public Condition likeRight(Object value){
        return new Condition(this, Then.LIKE, value.toString() + "%");
    }

    /**
     * Condition
     *
     *      ${PROPERTY} LIKE '%value%'
     *
     * @return
     *      Condition
     */
    public Condition like(Object value){
        return new Condition(this, Then.LIKE, "%"+value.toString() + "%");
    }



    public OrderBy desc(){
        return new OrderBy(this, OrderBy.Order.DESC);
    }


    public OrderBy asc() {
        return new OrderBy(this, OrderBy.Order.ASC);
    }
}
