package cn.ipokerface.mybatis.mapper;


import cn.ipokerface.mybatis.query.Where;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public interface AbstractMapper<T, K> {

    /**
     *  全量插入
     *
     * @param entity
     *      插入的数据实体
     * @return
     *      success row count
     */
    int insert(T entity);

    /**
     *  插入不是空的字段
     *
     * @param entity
     *      插入的数据实体
     * @return
     *      success row count
     */
    int insertSelective(T entity);

    /**
     *  批量插入
     *
     * @param entities
     *      插入的数据实体
     * @return
     *      success row count
     */
    int insertBatch(List<T> entities);

    /**
     *  通过主键删除
     *
     * @param key
     *      主键
     * @return
     *      success row count
     */
    int deleteByPrimaryKey(K key);

    /**
     *  通过条件删除
     *
     * @param condition
     *      条件  {@link cn.ipokerface.mybatis.query.Condition}
     * @return
     *      success row count
     */
    int deleteByCondition(@Param("condition") Where condition);

    /**
     *  通过主键修改
     *
     * @param entity
     *      实体
     * @return
     *      success row count
     */
    int updateByPrimaryKey(T entity);


    /**
     *  通过主键修改不为空的字段
     *
     * @param entity
     *      实体
     * @return
     *      success row count
     */
    int updateByPrimaryKeySelective(T entity);


    /**
     *  通过条件修改
     *
     * @param condition
     *       条件 {@link cn.ipokerface.mybatis.query.Condition}
     * @param entity
     *       对象
     * @return
     *      success row count
     */
    int updateByCondition(@Param("entity") T entity, @Param("condition") Where condition);


    /**
     *  通过条件修改不为空的字段
     *
     * @param condition
     *      条件 {@link cn.ipokerface.mybatis.query.Condition}
     * @param entity
     *      实例
     * @return
     *      success row count
     */
    int updateByConditionSelective(@Param("entity") T entity, @Param("condition") Where condition);



    /**
     *  通过主键查实体
     *
     * @param key
     *      主健
     * @return
     *      实例
     */
    T entityByPrimaryKey(K key);

    /**
     *  通过条件查实体
     *
     * @param condition
     *      条件 {@link cn.ipokerface.mybatis.query.Condition}
     * @return
     *      实例
     */
    T entityByCondition(@Param("condition") Where condition);

    /**
     *  通过条件查列表
     *
     * @param condition
     *      条件 {@link cn.ipokerface.mybatis.query.Condition}
     * @return
     *      list
     */
    List<T> selectByCondition(@Param("condition") Where condition);

    /**
     *  通过条件查总数
     *
     * @param condition
     *      条件 {@link cn.ipokerface.mybatis.query.Condition}
     * @return
     *      总数
     */
    Long countByCondition(@Param("condition") Where condition);


}
