/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.mybatis.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;

public class MybatisCommentGenerator
extends DefaultCommentGenerator {
    private boolean suppressAllComments;

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("//");
        sb.append("   [");
        sb.append(introspectedColumn.getActualColumnName());
        sb.append("]    ");
        sb.append(introspectedColumn.getRemarks() == null ? "" : introspectedColumn.getRemarks());
        field.addJavaDocLine(sb.toString());
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        StringBuilder comments = new StringBuilder("/**\r\n");
        comments.append(" * @author      #{author}\r\n");
        comments.append(" * @Date        ");
        comments.append(new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        comments.append("\r\n");
        comments.append(" * @Email       <a> href=\"#{email}\">#{email}</a>\r\n");
        comments.append(" *\r\n");
        comments.append(" * @version     #{version}\r\n");
        comments.append(" *\r\n");
        comments.append(" * @Description ");
        comments.append("     ");
        comments.append("\r\n");
        comments.append(" */");
        topLevelClass.addJavaDocLine(comments.toString());
    }
}

