package cn.ipokerface.mybatis.generator;

import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.codegen.XmlConstants;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.*;

import static org.mybatis.generator.internal.util.messages.Messages.getString;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public class XMLOperatorMapperGenerator extends AbstractXmlGenerator {

    public XMLOperatorMapperGenerator() {
        super();
    }

    protected XmlElement getSqlMapElement() {
        FullyQualifiedTable table = introspectedTable.getFullyQualifiedTable();
        progressCallback.startTask(getString(
                "Progress.12", table.toString())); //$NON-NLS-1$
        XmlElement answer = new XmlElement("mapper"); //$NON-NLS-1$
        String namespace = introspectedTable.getMyBatis3SqlMapNamespace();
        answer.addAttribute(new Attribute("namespace", //$NON-NLS-1$
                namespace));

        context.getCommentGenerator().addRootComment(answer);



        addResultMapElement(answer);
        addConditionWhereClauseElement(answer);
        addBaseColumnListElement(answer);


        addInsertElement(answer);
        addInsertSelectiveElement(answer);
        addInsertBatchElement(answer);

        addDeleteByPrimaryKeyElement(answer);
        addDeleteByConditionElement(answer);

        addUpdateByPrimaryKeyElement(answer);
        addUpdateByPrimaryKeySelectiveElement(answer);
        addUpdateByConditionElement(answer);
        addUpdateByConditionSelectiveElement(answer);

        addEntityByPrimaryKeyElement(answer);
        addEntityByConditionElement(answer);
        addSelectByConditionElement(answer);


        addCountByConditionElement(answer);

        return answer;
    }

    protected void addResultMapElement(XmlElement parentElement) {

        BaseResultMapElementGenerator elementGenerator = new BaseResultMapElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }


    protected void addBaseColumnListElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new BaseColumnListElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addBlobColumnListElement(XmlElement parentElement) {
        if (introspectedTable.getRules().generateBlobColumnList()) {
            AbstractXmlElementGenerator elementGenerator = new BlobColumnListElementGenerator();
            initializeAndExecuteGenerator(elementGenerator, parentElement);
        }
    }

    protected void addConditionWhereClauseElement(XmlElement parentElement) {
        // 添加查询条件
        AbstractXmlElementGenerator elementGenerator = new ConditionWhereClauseElementGenerator(
                false);
        initializeAndExecuteGenerator(elementGenerator, parentElement);

        // 添加修改条件
        AbstractXmlElementGenerator elementGenerator1 = new ConditionWhereClauseElementGenerator(
                true);
        initializeAndExecuteGenerator(elementGenerator1, parentElement);

    }


    protected void addInsertElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new InsertElementGenerator(false);
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addInsertSelectiveElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new InsertSelectiveElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addInsertBatchElement(XmlElement parentElement){
        AbstractXmlElementGenerator elementGenerator = new InsertBatchElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);
    }




    protected void addDeleteByConditionElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new DeleteByConditionElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addDeleteByPrimaryKeyElement(XmlElement parentElement) {

        AbstractOperatorXmlElementGenerator elementGenerator = new DeleteByPrimaryKeyElementGenerator(false);
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addUpdateByPrimaryKeyElement(
            XmlElement parentElement) {
        AbstractXmlElementGenerator elementGenerator = new UpdateByPrimaryKeyElementGenerator(false);
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }



    protected void addUpdateByPrimaryKeySelectiveElement(
            XmlElement parentElement) {
        AbstractXmlElementGenerator elementGenerator = new UpdateByPrimaryKeySelectiveGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addUpdateByConditionElement(
            XmlElement parentElement) {
        if (introspectedTable.getRules().generateUpdateByExampleWithoutBLOBs()) {
            AbstractXmlElementGenerator elementGenerator = new UpdateByConditionElementGenerator();
            initializeAndExecuteGenerator(elementGenerator, parentElement);
        }
    }

    protected void addUpdateByConditionSelectiveElement(XmlElement parentElement) {
        if (introspectedTable.getRules().generateUpdateByExampleSelective()) {
            AbstractXmlElementGenerator elementGenerator = new UpdateByConditionSelectiveElementGenerator();
            initializeAndExecuteGenerator(elementGenerator, parentElement);
        }
    }

    protected void addEntityByPrimaryKeyElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new EntityByPrimaryKeyElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }

    protected void addEntityByConditionElement(XmlElement parentElement) {
        if (introspectedTable.getRules().generateSelectByPrimaryKey()) {
            AbstractXmlElementGenerator elementGenerator = new EntityByConditionElementGenerator();
            initializeAndExecuteGenerator(elementGenerator, parentElement);
        }
    }



    protected void addSelectByConditionElement(
            XmlElement parentElement) {
        AbstractXmlElementGenerator elementGenerator = new SelectByConditionElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }



    protected void addCountByConditionElement(XmlElement parentElement) {

        AbstractXmlElementGenerator elementGenerator = new CountByConditionElementGenerator();
        initializeAndExecuteGenerator(elementGenerator, parentElement);

    }






    protected void initializeAndExecuteGenerator(
            AbstractXmlElementGenerator elementGenerator,
            XmlElement parentElement) {
        elementGenerator.setContext(context);
        elementGenerator.setIntrospectedTable(introspectedTable);
        elementGenerator.setProgressCallback(progressCallback);
        elementGenerator.setWarnings(warnings);
        elementGenerator.addElements(parentElement);
    }

    @Override
    public Document getDocument() {
        Document document = new Document(
                XmlConstants.MYBATIS3_MAPPER_PUBLIC_ID,
                XmlConstants.MYBATIS3_MAPPER_SYSTEM_ID);
        document.setRootElement(getSqlMapElement());

        if (!context.getPlugins().sqlMapDocumentGenerated(document,
                introspectedTable)) {
            document = null;
        }

        return document;
    }
}