package cn.ipokerface.mybatis.generator;

import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public class DeleteByConditionElementGenerator extends
        AbstractOperatorXmlElementGenerator {

    public DeleteByConditionElementGenerator() {
        super();
    }

    @Override
    public void addElements(XmlElement parentElement) {
        XmlElement answer = new XmlElement("delete"); //$NON-NLS-1$


        answer.addAttribute(new Attribute(
                "id", "deleteByCondition")); //$NON-NLS-1$
        answer.addAttribute(new Attribute("parameterType", "cn.ipokerface.mybatis.query.Where")); //$NON-NLS-1$

        context.getCommentGenerator().addComment(answer);

        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM "); //$NON-NLS-1$
        sb.append(introspectedTable
                .getAliasedFullyQualifiedTableNameAtRuntime());
        answer.addElement(new TextElement(sb.toString()));
        answer.addElement(getConditionWhereCommonIncludeElement());

        if (context.getPlugins().sqlMapDeleteByExampleElementGenerated(
                answer, introspectedTable)) {
            parentElement.addElement(answer);
        }
    }
}