package cn.ipokerface.mybatis.generator;

import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.AbstractXmlElementGenerator;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public class ConditionWhereClauseElementGenerator extends AbstractXmlElementGenerator {

    private boolean isForUpdate;

    public ConditionWhereClauseElementGenerator(boolean isForUpdate) {
        super();
        this.isForUpdate = isForUpdate;
    }

    @Override
    public void addElements(XmlElement parentElement) {
        XmlElement answer = new XmlElement("sql"); //$NON-NLS-1$

        if (isForUpdate) {
            answer
                    .addAttribute(new Attribute(
                            "id", "Condition_Where_Common_Clause")); //$NON-NLS-1$
        } else {
            answer.addAttribute(new Attribute(
                    "id", "Condition_Where_List_Clause")); //$NON-NLS-1$
        }
        context.getCommentGenerator().addComment(answer);

        XmlElement ifElement = new XmlElement("if"); //$NON-NLS-1$
        ifElement.addAttribute(new Attribute("test", "condition != null"));
        answer.addElement(ifElement);

        XmlElement whereElement = new XmlElement("where"); //$NON-NLS-1$
        ifElement.addElement(whereElement);

        XmlElement trimAndElement = new XmlElement("trim");
        trimAndElement.addAttribute(new Attribute("prefixOverrides", "AND"));
        whereElement.addElement(trimAndElement);

        XmlElement trimOrElement = new XmlElement("trim");
        trimOrElement.addAttribute(new Attribute("prefixOverrides", "OR"));
        trimAndElement.addElement(trimOrElement);


        XmlElement foreachElement = new XmlElement("foreach");
        trimOrElement.addElement(foreachElement);
        foreachElement.addAttribute(new Attribute("collection", "condition.conditions"));
        foreachElement.addAttribute(new Attribute("item", "item"));

        XmlElement chooseElement = new XmlElement("choose");
        foreachElement.addElement(chooseElement);

        XmlElement whenCase1Element = new XmlElement("when");
        chooseElement.addElement(whenCase1Element);
        whenCase1Element.addAttribute(new Attribute("test", "item.condition.singleValue"));

        whenCase1Element.addElement(new TextElement("${item.conn.value}\r"));
        whenCase1Element.addElement(new TextElement("${item.condition.property.column}\r"));
        whenCase1Element.addElement(new TextElement("${item.condition.then.value}\r"));
        whenCase1Element.addElement(new TextElement("#{item.condition.value}"));

        XmlElement whenCase2Element = new XmlElement("when");
        chooseElement.addElement(whenCase2Element);
        whenCase2Element.addAttribute(new Attribute("test", "item.condition.noValue"));

        whenCase2Element.addElement(new TextElement("${item.conn.value}\r"));
        whenCase2Element.addElement(new TextElement("${item.condition.property.column}\r"));
        whenCase2Element.addElement(new TextElement("${item.condition.then.value}\r"));


        XmlElement whenCase3Element = new XmlElement("when");
        chooseElement.addElement(whenCase3Element);
        whenCase3Element.addAttribute(new Attribute("test", "item.condition.doubleValue"));

        whenCase3Element.addElement(new TextElement("${item.conn.value}\r"));
        whenCase3Element.addElement(new TextElement("("));
        whenCase3Element.addElement(new TextElement("${item.condition.property.column}\r"));
        whenCase3Element.addElement(new TextElement("#{item.condition.value} AND #{item.condition.secondValue}\r"));
        whenCase3Element.addElement(new TextElement(")"));

        XmlElement whenCase4Element = new XmlElement("when");
        chooseElement.addElement(whenCase4Element);
        whenCase4Element.addAttribute(new Attribute("test",
                "item.condition.multiValue and item.condition.listValue != null and item.condition.listValue.size() !=0"));

        XmlElement caseForeachElement = new XmlElement("foreach");
        whenCase4Element.addElement(caseForeachElement);
        caseForeachElement.addAttribute(new Attribute("collection", "item.condition.listValue"));
        caseForeachElement.addAttribute(new Attribute("item","listItem"));
        caseForeachElement.addAttribute(new Attribute("close",")"));
        caseForeachElement.addAttribute(new Attribute("open","("));
        caseForeachElement.addAttribute(new Attribute("separator", ","));

        caseForeachElement.addElement(new TextElement("#{listItem}"));


        if (!isForUpdate){
            XmlElement orderByElement = new XmlElement("if");
            ifElement.addElement(orderByElement);
            orderByElement.addAttribute(new Attribute("test","condition.orderBy != null and condition.orderBy.property != null and condition.orderBy.order != null"));
            orderByElement.addElement(new TextElement("ORDER BY ${condition.orderBy.property.column} ${condition.orderBy.order.value}"));

        }

        XmlElement endElement = new XmlElement("if");
        ifElement.addElement(endElement);
        endElement.addAttribute(new Attribute("test","condition.end != null and condition.end != ''"));
        endElement.addElement(new TextElement("${condition.end}"));


        if(!isForUpdate){
            XmlElement limitElement = new XmlElement("if");
            ifElement.addElement(limitElement);
            limitElement.addAttribute(new Attribute("test","condition.limit != null"));
            limitElement.addElement(new TextElement("LIMIT #{condition.limit.start},#{condition.limit.size}"));

        }


        parentElement.addElement(answer);


    }


}
