package cn.ipokerface.mybatis.core;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2019-10-21.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * <p>
 * Description:
 */
public class MybatisCommentGenerator extends DefaultCommentGenerator {


    private boolean suppressAllComments;



    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (suppressAllComments) {
            return;
        }
        // 添加字段注释
        StringBuffer sb = new StringBuffer();
        sb.append("//");
        sb.append("   [");
        sb.append(introspectedColumn.getActualColumnName());
        sb.append("]    ");
        sb.append(introspectedColumn.getRemarks()==null?"":introspectedColumn.getRemarks());
        field.addJavaDocLine(sb.toString());
    }


    @Override
    public void addJavaFileComment(CompilationUnit compilationUnit) {

    }


    @Override
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        StringBuilder comments = new StringBuilder("/**\r\n");
        comments.append(" * @author      #{author}\r\n");
        comments.append(" * @Date        ");
        comments.append(new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        comments.append("\r\n");
        comments.append(" * @Email       <a> href=\"#{email}\">#{email}</a>\r\n");
        comments.append(" *\r\n");
        comments.append(" * @version     #{version}\r\n");
        comments.append(" *\r\n");
        comments.append(" * @Description ");
        comments.append("     ");
        comments.append("\r\n");
        comments.append(" */");

        topLevelClass.addJavaDocLine(comments.toString());
    }






}
