package cn.ipokerface.minio.service;

import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.minio.MinioProperties;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import io.minio.errors.*;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

/**
 * Created by       PokerFace
 * Create Date      2021/3/14.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Service
public class FileUploadServiceMinioImpl implements FileUploadService{

    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceMinioImpl.class);

    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    @Override
    public String upload(InputStream file,long size,String bucket, String originalName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        String fileName = UUID.randomUUID().toString().replace("-","")+"."+ FilenameUtils.getExtension(originalName);
        minioClient.putObject(bucket,
                fileName, file,
                new PutObjectOptions(size, PutObjectOptions.MIN_MULTIPART_SIZE) );

        logger.debug("upload object into minio server bucket: {} object:{}",bucket, fileName);
        return StringUtils.isEmpty(minioProperties.getLocationPrefix()) ? minioClient.getObjectUrl(bucket, fileName) :objectUrl(bucket, fileName);
    }


    public String objectUrl(String bucket, String name) {
        String prefix = StringUtils.isEmpty(minioProperties.getLocationPrefix())? minioProperties.getUrl() : minioProperties.getLocationPrefix();
        return new StringBuilder(prefix)
                .append(prefix.endsWith("/")?"":"/")
                .append(bucket).append("/")
                .append(name)
                .toString();
    }


}
