/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.minio.service;

import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.minio.MinioProperties;
import cn.ipokerface.minio.service.FileUploadService;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileUploadServiceMinioImpl
implements FileUploadService {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceMinioImpl.class);
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    @Override
    public String upload(InputStream file, long size, String bucket, String originalName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException {
        String fileName = UUID.randomUUID().toString().replace("-", "") + "." + FilenameUtils.getExtension((String)originalName);
        this.minioClient.putObject(bucket, fileName, file, new PutObjectOptions(size, 0x500000L));
        logger.debug("upload object into minio server bucket: {} object:{}", (Object)bucket, (Object)fileName);
        return StringUtils.isEmpty((Object)this.minioProperties.getLocationPrefix()) ? this.minioClient.getObjectUrl(bucket, fileName) : this.objectUrl(bucket, fileName);
    }

    @Override
    public String objectUrl(String bucket, String name) {
        String prefix = StringUtils.isEmpty((Object)this.minioProperties.getLocationPrefix()) ? this.minioProperties.getUrl() : this.minioProperties.getLocationPrefix();
        return prefix + (prefix.endsWith("/") ? "" : "/") + bucket + "/" + name;
    }
}

