/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.minio.controller;

import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.minio.MinioProperties;
import cn.ipokerface.minio.model.UrlModel;
import cn.ipokerface.minio.service.FileUploadService;
import java.io.IOException;
import java.rmi.ServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/support/upload"})
public class UploadController {
    private static final Logger logger = LoggerFactory.getLogger(UploadController.class);
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private MinioProperties minioProperties;

    @RequestMapping(value={"/standard"}, method={RequestMethod.POST})
    public ResultBody standard(@RequestParam(value="file") MultipartFile file, String bucket) throws IOException {
        bucket = StringUtils.isEmpty((Object)bucket) ? this.minioProperties.getDefaultBucket() : bucket;
        try {
            String url = this.fileUploadService.upload(file.getInputStream(), file.getSize(), bucket, file.getOriginalFilename());
            return ResultBody.builder().data((BaseModel)new UrlModel(url)).build();
        }
        catch (Exception e) {
            logger.error(" upload object into minio server error: {}", (Object)e.getMessage());
            throw new ServerException("upload error");
        }
    }
}

