/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.minio;

import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.minio.MinioProperties;
import io.minio.MinioClient;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MinioInitializingBean
extends LoggerAdapter
implements InitializingBean {
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    public void afterPropertiesSet() throws Exception {
        String[] buckets;
        if (!this.minioClient.bucketExists(this.minioProperties.getBuckets()) && (buckets = this.minioProperties.getBuckets().split(",")) != null) {
            Arrays.stream(buckets).forEach(bucket -> {
                try {
                    this.minioClient.makeBucket(bucket);
                }
                catch (Exception e) {
                    this.error(e);
                }
            });
        }
    }
}

