package cn.ipokerface.minio.service;

import io.minio.errors.*;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * Created by       PokerFace
 * Create Date      2021/3/14.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface FileUploadService {

    /**
     * 上传文件并返回文件的访问url
     *
     * @param inputStream inputStream
     * @param size size
     * @param  bucket bucket
     * @param originalName originalName
     * @return object url
     */
    String upload(InputStream inputStream,long size,String bucket, String originalName) throws ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidBucketNameException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException;


    /**
     *  获取object url
     *
     * @param bucket bucket
     * @param name object name
     * @return object url
     */
    String objectUrl(String bucket,String name);
}
