package cn.ipokerface.minio;

import cn.ipokerface.common.logback.LoggerAdapter;
import io.minio.MinioClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;

/**
 * Created by       PokerFace
 * Create Date      2021/4/18.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
public class MinioInitializingBean extends LoggerAdapter implements InitializingBean {


    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    @Override
    public void afterPropertiesSet() throws Exception {

        if (!minioClient.bucketExists(minioProperties.getBuckets())) {
            String[] buckets = minioProperties.getBuckets().split(",");
            if (buckets!=null){
                Arrays.stream(buckets).forEach(bucket -> {
                    try {
                        minioClient.makeBucket(bucket);
                    }catch (Exception e){
                        error(e);
                    }
                });
            }
        }
    }
}
