package cn.ipokerface.minio;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2021/3/14.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
@Configuration
@EnableConfigurationProperties({MinioProperties.class})
public class MinioAutoConfiguration {

    @Autowired
    private MinioProperties minioProperties;

    @Bean
    public MinioClient minioClient() throws InvalidEndpointException, InvalidPortException {
        return new MinioClient(minioProperties.getUrl(),
                minioProperties.getAccessKey(),
                minioProperties.getSecretKey());
    }

}
