/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import java.util.Random;

public class ShareCodeUtils {
    private static final char[] BASE = new char[]{'H', 'V', 'E', '8', 'S', '2', 'D', 'Z', 'X', '9', 'C', '7', 'P', '5', 'I', 'K', '3', 'M', 'J', 'U', 'F', 'R', '4', 'W', 'Y', 'L', 'T', 'N', '6', 'B', 'G', 'Q'};
    private static final char SUFFIX_CHAR = 'A';
    private static final int BIN_LEN = BASE.length;
    private static final int CODE_LEN = 6;

    public static String idToCode(Long id) {
        char[] buf = new char[BIN_LEN];
        int charPos = BIN_LEN;
        while (id / (long)BIN_LEN > 0L) {
            int index = (int)(id % (long)BIN_LEN);
            buf[--charPos] = BASE[index];
            id = id / (long)BIN_LEN;
        }
        buf[--charPos] = BASE[(int)(id % (long)BIN_LEN)];
        String result = new String(buf, charPos, BIN_LEN - charPos);
        int len = result.length();
        if (len < 6) {
            StringBuilder sb = new StringBuilder();
            sb.append('A');
            Random random = new Random();
            for (int i = 0; i < 6 - len - 1; ++i) {
                sb.append(BASE[random.nextInt(BIN_LEN)]);
            }
            result = result + sb.toString();
        }
        return result;
    }

    public static Long codeToId(String code) {
        char[] charArray = code.toCharArray();
        long result = 0L;
        for (int i = 0; i < charArray.length; ++i) {
            int index = 0;
            for (int j = 0; j < BIN_LEN; ++j) {
                if (charArray[i] != BASE[j]) continue;
                index = j;
                break;
            }
            if (charArray[i] == 'A') break;
            result = i > 0 ? result * (long)BIN_LEN + (long)index : (long)index;
        }
        return result;
    }
}

