/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RSADigestUtils {
    public static final String ENCRYPT_TYPE = "RSA";

    public KeyPairInfo getKeyPair() throws NoSuchAlgorithmException {
        return this.getKeyPair(1024);
    }

    public KeyPairInfo getKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ENCRYPT_TYPE);
        keyPairGen.initialize(keySize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey oraprivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey orapublicKey = (RSAPublicKey)keyPair.getPublic();
        KeyPairInfo pairInfo = new KeyPairInfo(keySize);
        byte[] publicKeybyte = orapublicKey.getEncoded();
        String publicKeyString = Base64.encodeBase64String((byte[])publicKeybyte);
        pairInfo.setPublicKey(publicKeyString);
        byte[] privateKeybyte = oraprivateKey.getEncoded();
        String privateKeyString = Base64.encodeBase64String((byte[])privateKeybyte);
        pairInfo.setPrivateKey(privateKeyString);
        return pairInfo;
    }

    public static PublicKey getPublicKey(String publicKeyBase64) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPT_TYPE);
        X509EncodedKeySpec publicpkcs8KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyBase64));
        PublicKey publicKey = keyFactory.generatePublic(publicpkcs8KeySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String privateKeyBase64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPT_TYPE);
        PKCS8EncodedKeySpec privateKCS8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyBase64));
        PrivateKey privateKey = keyFactory.generatePrivate(privateKCS8KeySpec);
        return privateKey;
    }

    public static String encipher(String content, String publicKeyBase64) {
        return RSADigestUtils.encipher(content, publicKeyBase64, 117);
    }

    public static String encipher(String content, String publicKeyBase64, int segmentSize) {
        try {
            PublicKey publicKey = RSADigestUtils.getPublicKey(publicKeyBase64);
            return RSADigestUtils.encipher(content, publicKey, segmentSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encipher(String ciphertext, Key key, int segmentSize) {
        try {
            byte[] srcBytes = ciphertext.getBytes();
            Cipher cipher = Cipher.getInstance(ENCRYPT_TYPE);
            cipher.init(1, key);
            byte[] resultBytes = null;
            resultBytes = segmentSize > 0 ? RSADigestUtils.cipherDoFinal(cipher, srcBytes, segmentSize) : cipher.doFinal(srcBytes);
            String base64Str = Base64.encodeBase64String((byte[])resultBytes);
            return base64Str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] cipherDoFinal(Cipher cipher, byte[] srcBytes, int segmentSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        if (segmentSize <= 0) {
            throw new RuntimeException("\u5206\u6bb5\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int inputLen = srcBytes.length;
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > segmentSize ? cipher.doFinal(srcBytes, offSet, segmentSize) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * segmentSize;
        }
        byte[] data = out.toByteArray();
        out.close();
        return data;
    }

    public static String decipher(String contentBase64, String privateKeyBase64) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        return RSADigestUtils.decipher(contentBase64, privateKeyBase64, 128);
    }

    public static String decipher(String contentBase64, String privateKeyBase64, int segmentSize) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException, IOException {
        PrivateKey privateKey = RSADigestUtils.getPrivateKey(privateKeyBase64);
        return RSADigestUtils.decipher(contentBase64, privateKey, segmentSize);
    }

    public static String decipher(String contentBase64, Key key, int segmentSize) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] srcBytes = Base64.decodeBase64((String)contentBase64);
        Cipher deCipher = Cipher.getInstance(ENCRYPT_TYPE);
        deCipher.init(2, key);
        byte[] decBytes = null;
        decBytes = segmentSize > 0 ? RSADigestUtils.cipherDoFinal(deCipher, srcBytes, segmentSize) : deCipher.doFinal(srcBytes);
        String decrytStr = new String(decBytes);
        return decrytStr;
    }

    public class KeyPairInfo {
        String privateKey;
        String publicKey;
        int keySize = 0;

        public KeyPairInfo(int keySize) {
            this.setKeySize(keySize);
        }

        public KeyPairInfo(String publicKey, String privateKey) {
            this.setPrivateKey(privateKey);
            this.setPublicKey(publicKey);
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public void setKeySize(int keySize) {
            this.keySize = keySize;
        }
    }
}

