/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import cn.ipokerface.common.utils.StringUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalTimeUtils {
    public static final String fmt_date_time = "yyyy-MM-dd HH:mm:ss";
    public static final String fmt_date_minute = "yyyy-MM-dd HH:mm";
    public static final String fmt_date = "yyyy-MM-dd";
    public static final String fmt_time = "HH:mm:ss";
    public static final String fmt_date_time_zh = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    public static final String fmt_date_time_zh_full = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String fmt_date_minute_zh = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final String fmt_date_minute_zh_full = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
    public static final String fmt_date_zh = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final long timestamp_millis = 1L;
    public static final long timestamp_seconds = 1000L;
    public static final long timestamp_minutes = 60000L;
    public static final long timestamp_hours = 3600000L;
    public static final long timestamp_days = 86400000L;
    public static final long timestamp_months = 2592000000L;
    public static final long timestamp_years = 31536000000L;

    public static String format(LocalDateTime time, String format) {
        if (time == null) {
            return "";
        }
        return DateTimeFormatter.ofPattern(format).format(time);
    }

    public static Long timestamp(LocalDateTime time, int offset) {
        if (time == null) {
            return null;
        }
        long millis = time.toInstant(ZoneOffset.ofHours(offset)).toEpochMilli();
        return millis;
    }

    public static Long timestamp(LocalDateTime time) {
        return LocalTimeUtils.timestamp(time, 8);
    }

    public static LocalDateTime parse(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static LocalDateTime parse(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(fmt_date_time));
    }
}

