/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.model.api;

import cn.ipokerface.common.model.BaseModel;

public class ResultBody<T>
extends BaseModel {
    public static final int CODE_SUCCESS = 10000;
    public static final int CODE_ERROR = 20000;
    public static final int CODE_NOT_FOUND = 20001;
    public static final int CODE_ILLEGAL = 20002;
    public static final int CODE_ACCESS = 20010;
    public static final int CODE_AUTHORIZATION = 20020;
    private int code;
    private String message;
    private Long timestamp;
    private T body;

    public ResultBody() {
        this.code = 10000;
        this.message = "SUCCESS";
    }

    private ResultBody(int code, String message, long timestamp, T body) {
        this.code = code;
        this.body = body;
        this.message = message;
        this.timestamp = timestamp;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public static <T> ResultBody<T> success() {
        return ResultBody.success(null);
    }

    public static <T> ResultBody<T> success(T data) {
        ResultBody<T> resultBody = new ResultBody<T>();
        resultBody.code = 10000;
        resultBody.message = "SUCCESS";
        resultBody.timestamp = System.currentTimeMillis();
        resultBody.body = data;
        return resultBody;
    }

    public static ResultBody error(int code, String message) {
        ResultBody resultBody = new ResultBody();
        resultBody.code = code;
        resultBody.message = message;
        resultBody.timestamp = System.currentTimeMillis();
        return resultBody;
    }

    public static ResultBody error(String message) {
        return ResultBody.error(20000, message);
    }

    public static ResultBody error() {
        return ResultBody.error("ERROR");
    }
}

