/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.fastjson.serilizer;

import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;

public class DateTimeFormatSerializer
implements ObjectSerializer {
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter serializerWriter = serializer.out;
        if (object == null) {
            serializerWriter.write("\"\"");
            return;
        }
        serializerWriter.write("\"");
        if (object instanceof LocalDateTime) {
            serializerWriter.write(LocalTimeUtils.format((LocalDateTime)object, "yyyy-MM-dd HH:mm:ss"));
        } else if (object instanceof Date) {
            serializerWriter.write(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)object));
        }
        serializerWriter.write("\"");
    }
}

