/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.fastjson;

import cn.ipokerface.common.fastjson.filters.NullValueFilter;
import cn.ipokerface.common.fastjson.serilizer.DateTimestampSerializer;
import cn.ipokerface.common.fastjson.serilizer.LocalTimeSerializer;
import cn.ipokerface.common.fastjson.serilizer.LongSerializer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public class Fastjson {
    public static SerializeConfig serializeConfig() {
        return SerializeConfig.globalInstance;
    }

    public static SerializerFeature[] serializerFeatures() {
        return new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.SkipTransientField, SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.IgnoreErrorGetter, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteBigDecimalAsPlain, SerializerFeature.WriteNonStringKeyAsString};
    }

    public static SerializeFilter[] serializeFilters() {
        return new SerializeFilter[]{new NullValueFilter()};
    }

    public static String format(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SerializeConfig.globalInstance, (SerializeFilter[])Fastjson.serializeFilters(), (String)"yyyy-MM-dd HH:mm:ss", (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])Fastjson.serializerFeatures());
    }

    public static <T> T parseObject(String ret, Class<T> clazz) {
        ParserConfig config = ParserConfig.global;
        Feature[] features = new Feature[]{};
        return (T)JSON.parseObject((String)ret, clazz, (ParserConfig)config, null, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])features);
    }

    public static <T> List<T> parseArray(String ret, Class<T> clazz) {
        ParserConfig config = ParserConfig.global;
        return JSONArray.parseArray((String)ret, clazz, (ParserConfig)config);
    }

    static {
        SerializeConfig config = SerializeConfig.globalInstance;
        config.put(LocalDateTime.class, (ObjectSerializer)new DateTimestampSerializer());
        config.put(LocalTime.class, (ObjectSerializer)new LocalTimeSerializer());
        config.put(Long.class, (ObjectSerializer)new LongSerializer());
    }
}

