/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.digest;

import cn.ipokerface.common.utils.StringUtils;

public class FakeEncrypt {
    private byte[] encrypt_salt = new byte[32];
    private byte[] decrypt_salt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public FakeEncrypt(String salt) {
        if (StringUtils.isEmpty((CharSequence)salt) || salt.length() != 32) {
            throw new IllegalArgumentException("Salt should be 16 bytes of data");
        }
        this.encrypt_salt = salt.getBytes();
        for (int i = 0; i < this.encrypt_salt.length; i = (int)((byte)(i + 1))) {
            byte b = this.encrypt_salt[i];
            this.decrypt_salt[b] = i;
        }
    }

    public byte[] encode(byte[] bytes) {
        int byte2;
        int byte1;
        int byte0;
        int length = bytes.length;
        int groupCount = length / 5;
        int paddingBytes = length % 5;
        int resultLen = 8 * groupCount + (paddingBytes == 0 ? 0 : (paddingBytes == 1 ? 2 : (paddingBytes == 2 ? 4 : (paddingBytes == 3 ? 5 : 7))));
        byte[] result = new byte[resultLen];
        int resultIndex = 0;
        int in = 0;
        for (int i = 0; i < groupCount; ++i) {
            int byte02 = bytes[in++] & 0xFF;
            int byte12 = bytes[in++] & 0xFF;
            int byte22 = bytes[in++] & 0xFF;
            int byte3 = bytes[in++] & 0xFF;
            int byte4 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte02 >> 3 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte02 << 2 & 0x1F | byte12 >> 6];
            result[resultIndex++] = this.encrypt_salt[byte12 >> 1 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte12 << 4 & 0x1F | byte22 >> 4];
            result[resultIndex++] = this.encrypt_salt[byte22 << 1 & 0x1F | byte3 >> 7];
            result[resultIndex++] = this.encrypt_salt[byte3 >> 2 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte3 << 3 & 0x1F | byte4 >> 5];
            result[resultIndex++] = this.encrypt_salt[byte4 & 0x1F];
        }
        if (paddingBytes == 1) {
            byte0 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 3 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte0 << 2 & 0x1F];
        } else if (paddingBytes == 2) {
            byte0 = bytes[in++] & 0xFF;
            byte1 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 3 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte0 << 2 & 0x1F | byte1 >> 6];
            result[resultIndex++] = this.encrypt_salt[byte1 >> 1 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte1 << 4 & 0x1F];
        } else if (paddingBytes == 3) {
            byte0 = bytes[in++] & 0xFF;
            byte1 = bytes[in++] & 0xFF;
            byte2 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 3 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte0 << 2 & 0x1F | byte1 >> 6];
            result[resultIndex++] = this.encrypt_salt[byte1 >> 1 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte1 << 4 & 0x1F | byte2 >> 4];
            result[resultIndex++] = this.encrypt_salt[byte2 << 1 & 0x1F];
        } else if (paddingBytes == 4) {
            byte0 = bytes[in++] & 0xFF;
            byte1 = bytes[in++] & 0xFF;
            byte2 = bytes[in++] & 0xFF;
            int byte3 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 3 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte0 << 2 & 0x1F | byte1 >> 6];
            result[resultIndex++] = this.encrypt_salt[byte1 >> 1 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte1 << 4 & 0x1F | byte2 >> 4];
            result[resultIndex++] = this.encrypt_salt[byte2 << 1 & 0x1F | byte3 >> 7];
            result[resultIndex++] = this.encrypt_salt[byte3 >> 2 & 0x1F];
            result[resultIndex++] = this.encrypt_salt[byte3 << 3 & 0x1F];
        }
        return result;
    }

    public String encodeString(String data) {
        return new String(this.encode(data.getBytes()));
    }

    public byte[] decode(byte[] data) {
        byte ch4;
        byte ch3;
        byte ch2;
        byte ch1;
        byte ch0;
        if (data == null) {
            throw new IllegalArgumentException("String length must have value");
        }
        int groupCount = data.length / 8;
        int paddingCount = data.length % 8;
        int missingBytes = paddingCount == 0 ? 0 : (paddingCount == 2 ? 1 : (paddingCount == 4 ? 2 : (paddingCount == 5 ? 3 : 4)));
        byte[] result = new byte[groupCount * 5 + missingBytes];
        int in = 0;
        int out = 0;
        for (int i = 0; i < groupCount; ++i) {
            byte ch02 = this.decrypt_salt[data[in++]];
            byte ch12 = this.decrypt_salt[data[in++]];
            byte ch22 = this.decrypt_salt[data[in++]];
            byte ch32 = this.decrypt_salt[data[in++]];
            byte ch42 = this.decrypt_salt[data[in++]];
            byte ch5 = this.decrypt_salt[data[in++]];
            byte ch6 = this.decrypt_salt[data[in++]];
            byte ch7 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch02 << 3 | ch12 >> 2);
            result[out++] = (byte)(ch12 << 6 | ch22 << 1 | ch32 >> 4);
            result[out++] = (byte)(ch32 << 4 | ch42 >> 1);
            result[out++] = (byte)(ch42 << 7 | ch5 << 2 | ch6 >> 3);
            result[out++] = (byte)(ch6 << 5 | ch7);
        }
        if (missingBytes == 1) {
            ch0 = this.decrypt_salt[data[in++]];
            ch1 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch0 << 3 | ch1 >> 2);
        } else if (missingBytes == 2) {
            ch0 = this.decrypt_salt[data[in++]];
            ch1 = this.decrypt_salt[data[in++]];
            ch2 = this.decrypt_salt[data[in++]];
            ch3 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch0 << 3 | ch1 >> 2);
            result[out++] = (byte)(ch1 << 6 | ch2 << 1 | ch3 >> 4);
        } else if (missingBytes == 3) {
            ch0 = this.decrypt_salt[data[in++]];
            ch1 = this.decrypt_salt[data[in++]];
            ch2 = this.decrypt_salt[data[in++]];
            ch3 = this.decrypt_salt[data[in++]];
            ch4 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch0 << 3 | ch1 >> 2);
            result[out++] = (byte)(ch1 << 6 | ch2 << 1 | ch3 >> 4);
            result[out++] = (byte)(ch3 << 4 | ch4 >> 1);
        } else if (missingBytes == 4) {
            ch0 = this.decrypt_salt[data[in++]];
            ch1 = this.decrypt_salt[data[in++]];
            ch2 = this.decrypt_salt[data[in++]];
            ch3 = this.decrypt_salt[data[in++]];
            ch4 = this.decrypt_salt[data[in++]];
            byte ch5 = this.decrypt_salt[data[in++]];
            byte ch6 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch0 << 3 | ch1 >> 2);
            result[out++] = (byte)(ch1 << 6 | ch2 << 1 | ch3 >> 4);
            result[out++] = (byte)(ch3 << 4 | ch4 >> 1);
            result[out++] = (byte)(ch4 << 7 | ch5 << 2 | ch6 >> 3);
        }
        return result;
    }

    public String decodeString(String str) {
        return new String(this.decode(str.getBytes()));
    }
}

