/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.digest;

import cn.ipokerface.common.utils.StringUtils;

public class Base64Encrypt {
    private byte[] encrypt_salt = new byte[64];
    private byte[] decrypt_salt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private byte padding;

    public Base64Encrypt(String salt, byte padding) {
        if (StringUtils.isEmpty((CharSequence)salt) || salt.length() != 64) {
            throw new IllegalArgumentException("Salt should be 64 bytes of data");
        }
        this.encrypt_salt = salt.getBytes();
        this.padding = padding;
        for (int i = 0; i < this.encrypt_salt.length; i = (int)((byte)(i + 1))) {
            byte b = this.encrypt_salt[i];
            this.decrypt_salt[b] = i;
        }
    }

    public byte[] encode(byte[] bytes) {
        int length = bytes.length;
        int groupCount = length / 3;
        int paddingBytes = length % 3;
        int paddingLength = length - paddingBytes;
        int resultLen = 4 * ((length + 2) / 3);
        byte[] result = new byte[resultLen];
        int resultIndex = 0;
        int in = 0;
        for (int i = 0; i < groupCount; ++i) {
            int byte0 = bytes[in++] & 0xFF;
            int byte1 = bytes[in++] & 0xFF;
            int byte2 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 2];
            result[resultIndex++] = this.encrypt_salt[byte0 << 4 & 0x3F | byte1 >> 4];
            result[resultIndex++] = this.encrypt_salt[byte1 << 2 & 0x3F | byte2 >> 6];
            result[resultIndex++] = this.encrypt_salt[byte2 & 0x3F];
        }
        if (paddingBytes == 1) {
            int byte0 = bytes[in++] & 0xFF;
            result[resultIndex++] = this.encrypt_salt[byte0 >> 2 & 0x3F];
            result[resultIndex++] = this.encrypt_salt[byte0 << 4 & 0x3F];
            result[resultIndex++] = this.padding;
            result[resultIndex++] = this.padding;
        }
        if (paddingBytes == 2) {
            result[resultIndex++] = this.encrypt_salt[(bytes[paddingLength] & 0xFF) >> 2 & 0x3F];
            result[resultIndex++] = this.encrypt_salt[(bytes[paddingLength] & 0xFF) << 4 & 0x3F | (bytes[paddingLength + 1] & 0xFF) >> 4 & 0x3F];
            result[resultIndex++] = this.encrypt_salt[bytes[paddingLength + 1] << 2 & 0x3F];
            result[resultIndex++] = this.padding;
        }
        return result;
    }

    public byte[] encode(String data) {
        return this.encode(data.getBytes());
    }

    public String encodeString(String str) {
        return new String(this.encode(str.getBytes()));
    }

    public byte[] decode(byte[] data) {
        if (data == null || data.length % 4 != 0) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int groupCount = data.length / 4;
        int missingBytes = 0;
        if (data.length != 0 && data[data.length - 1] == this.padding) {
            ++missingBytes;
            if (data[data.length - 2] == this.padding) {
                ++missingBytes;
            }
        }
        byte[] result = new byte[groupCount * 3 - missingBytes];
        int in = 0;
        int out = 0;
        for (int i = 0; i < groupCount; ++i) {
            byte ch2;
            byte ch1;
            byte ch0;
            if (i == groupCount - 1 && missingBytes > 0) {
                ch0 = this.decrypt_salt[data[in++]];
                ch1 = this.decrypt_salt[data[in++]];
                result[out++] = (byte)(ch0 << 2 | ch1 >> 4);
                if (missingBytes != 1) continue;
                ch2 = this.decrypt_salt[data[in++]];
                result[out++] = (byte)(ch1 << 4 | ch2 >> 2);
                continue;
            }
            ch0 = this.decrypt_salt[data[in++]];
            ch1 = this.decrypt_salt[data[in++]];
            ch2 = this.decrypt_salt[data[in++]];
            byte ch3 = this.decrypt_salt[data[in++]];
            result[out++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[out++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[out++] = (byte)(ch2 << 6 | ch3);
        }
        return result;
    }

    public byte[] decode(String str) {
        return this.decode(str.getBytes());
    }

    public String decodeString(String str) {
        return new String(this.decode(str.getBytes()));
    }
}

