package cn.ipokerface.common.utils;

import java.math.BigDecimal;

/**
 * Created by       PokerFace
 * Create Date      2021/4/26.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class PriceUtils {


    /**
     *  convert value of unit cent to unit yuan.
     *  ex:   cents = 300 -  return 3
     *        cents = 305    return 3.05
     *        cents 0 310    return 3.10
     *
     * @param cents  cents value to convert
     * @return yuan value of this cents value
     */
    public static String cent2Yuan(Long cents) {
        if (cents == null) return "0";

        Long yuan = cents / 100;
        Long cent = Math.abs(cents % 100);

        if (cent == 0) {
            return yuan.toString();
        }
        else if (cent < 10) {
            return yuan.toString() + ".0"+ cent;
        } else {
            return yuan.toString() + "." + cent;
        }
    }

    public static Long yuan2Cent(BigDecimal yuan)
    {
        if (yuan == null) return 0L;
        return yuan.multiply(new BigDecimal(100)).longValue();
    }

    public static Long yuan2Cent(String yuan)
    {
        BigDecimal bigDecimal = new BigDecimal(yuan);
        return yuan2Cent(bigDecimal);
    }
}
