package cn.ipokerface.common.utils;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

/**
 * Created by       PokerFace
 * Create Date      2021/5/18.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class LoggerBackUtils {


    /**
     *
     *
     * @param logger logger
     * @param ex  ex
     */
    public static void printError(Logger logger, Throwable ex) {
        printError(logger, ex, 20);
    }

    /**
     *  print error message
     *
     * @param logger logger name
     * @param ex    ex instance
     * @param limits lines limits
     */
    public static void printError(Logger logger, Throwable ex, int limits) {
        logger.error("--> handle exception: {}", ex.getClass().getName());
        logger.error("--> Error: {}", ex.getMessage());

        logger.error("--> StackTrace:");
        if (!ArrayUtils.isEmpty(ex.getStackTrace())) {
            for (int i=0; i < limits && i < ex.getStackTrace().length; i++) {
                StackTraceElement element = ex.getStackTrace()[i];
                logger.error("      {}.{}({}:{})", element.getClassName(),
                        element.getMethodName(),element.getFileName(),element.getLineNumber());
            }
        }
    }

}
