package cn.ipokerface.common.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

/**
 * Created by       mac
 * Create Date      2020/12/13
 * Version          1.0.0
 * Description:
 */
public class LocalTimeUtils {

    public static final String fmt_date_time =  "yyyy-MM-dd HH:mm:ss";

    public static final String fmt_date_minute =  "yyyy-MM-dd HH:mm";

    public static final String fmt_date = "yyyy-MM-dd";

    public static final String fmt_time = "HH:mm:ss";

    public static final String fmt_date_time_zh = "yyyy年MM月dd日 HH:mm:ss";

    public static final String fmt_date_time_zh_full = "yyyy年MM月dd日 HH时mm分ss秒";

    public static final String fmt_date_minute_zh =  "yyyy年MM月dd日 HH:mm";

    public static final String fmt_date_minute_zh_full =  "yyyy年MM月dd日 HH时mm分";

    public static final String fmt_date_zh = "yyyy年MM月dd日";


    public static final long timestamp_millis = 1L;

    public static final long timestamp_seconds = 1000 * timestamp_millis;

    public static final long timestamp_minutes = 60 * timestamp_seconds;

    public static final long timestamp_hours = 60 * timestamp_minutes;

    public static final long timestamp_days = 24 * timestamp_hours;

    public static final long timestamp_months = 30 * timestamp_days;

    public static final long timestamp_years = 365 * timestamp_days;


    /**
     * format timestring of localdatetime
     *
     * @param time      time instance
     * @param format    format
     * @return      format string
     */
    public static String format(LocalDateTime time, String format) {
        if (time == null) return "";
        return DateTimeFormatter.ofPattern(format).format(time);
    }


    /**
     * get timestamp of a time
     *
     * @param time      time instance
     * @param offset        time offset   8 of china
     * @return timestamp
     */
    public static Long timestamp(LocalDateTime time,int offset) {
        if (time == null) return null;
        // 将当前时间转为时间戳
        long millis = time.toInstant(ZoneOffset.ofHours(offset)).toEpochMilli();
        // 1580707001
        return millis;
    }


    /**
     * get timestamp of a time
     * {@link #timestamp(LocalDateTime, int)}  of +8 offset
     * @param time      time
     * @return  get +8 offset of time
     */
    public static Long timestamp(LocalDateTime time) {
        return timestamp(time, 8);
    }


    /**
     * parse by timestamp in millis
     *
     * @param timestamp timestamp
     * @return time
     */

    public static LocalDateTime parse(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }


    /**
     * parse by timestring yyyy-MM-dd HH:mm:ss
     *
     * @param time time
     * @return time
     */
    public static LocalDateTime parse(String time) {
        if (StringUtils.isEmpty(time)) return null;
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(fmt_date_time));
    }

}
