package cn.ipokerface.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.io.*;

/**
 * Created by       PokerFace
 * Create Date      2019-11-22.
 * Email:           
 * Version          1.0.0
 *
 * Description:     more {@link org.apache.commons.io.FileUtils}
 *
 */
public class FileUtils extends org.apache.commons.io.FileUtils {
    /**
     *  获取一个文件名的扩展名   .ext   .png
     *
     * @param filename
     *          文件名
     * @return
     *          文件名的扩展名
     */
    public static String fileExt(String filename){
        if (StringUtils.isEmpty(filename)) return null;
        if (filename.indexOf(".") < 0) return null;


        return filename.substring(filename.lastIndexOf(".") + 1, filename.length());
    }


    /**
     *  拼接文件夹名字   aaa 会转换成 aaa/
     *                 aaa/ 会返回 aaa/
     *
     * @param folderName folder name
     * @return name name
     */
    public static String folderWithSlash(String folderName) {
        if (StringUtils.isEmpty(folderName))
            return null;

        if (folderName.endsWith("/"))
            return folderName;

        return folderName + "/";
    }


    /**
     *  通过mime-type来判断是否是图片
     *
     * @param contentType media-type
     * @return  true if is image
     */
    public static boolean isImage(String contentType){

        return !StringUtils.isEmpty(contentType) && contentType.startsWith("image");
    }


    /**
     *
     *
     * @param source source
     * @param target target
     * @param override override
     * @throws IOException IOException
     */
    public static void copyFile(File source, File target, boolean override) throws IOException {
        if (source == null || !source.exists()) return;
        if (target.exists()){
            if (override) {
                target.delete();
            }else{
                return;
            }
        }
        writeTo(new FileInputStream(source), new FileOutputStream(target));
    }



    public static void writeTo(String file, OutputStream outputStream) throws IOException{
        writeTo(new File(file), outputStream);
    }


    public static void writeTo(File file, OutputStream outputStream) throws IOException {
        if (file == null || !file.exists()) return;
        writeTo(new FileInputStream(file), outputStream);
    }

    /**
     *  提供IO 的读写操作
     *  不会关闭操作流  需要自己关闭
     *
     * @param inputStream inputStream
     * @param outputStream outputStream
     * @throws IOException IOException
     */
    public static void writeTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (true){
            int b = inputStream.read(buffer);
            if (b <= 0 ) break;
            outputStream.write(buffer,0 , b);
        }
        outputStream.flush();
    }
}
