package cn.ipokerface.common.model.query;

import cn.ipokerface.common.model.BaseModel;

/**
 * Created by       PokerFace
 * Create Date      2021/8/18
 * Version          1.0.0
 * Description:
 */
public class PaginationQuery extends BaseModel {

    // pagination number
    private int size = 50;

    // pagination page number, use this will set cursor to null
    private int page = 0;
    // pagination cursor, use this will set page to 0. this maybe used in pull refresh scene.
    private String cursor;
    // unable to set only use to calculate pagination data.
    private long start = 0;


    public int getSize() {
        return size;
    }

    /**
     *  限制最多返回500条 默认50条
     *
     * @param size size
     */
    public void setSize(int size) {
        if (size > 500) size = 500;
        this.size = size;
        calculateStart();

    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
        calculateStart();

    }

    public long getStart() {
        return start;
    }

    public void setStart(long start) {
        this.start = start;
    }


    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    private void calculateStart()
    {
        this.start = this.page * this.size;
    }
}
