package cn.ipokerface.common.model.entity;

import cn.ipokerface.common.enums.State;

import java.time.LocalDateTime;

/**
 * Created by       PokerFace
 * Create Date      2021/4/2.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class BaseTableEntity extends BaseEntity {

    /**
     * 数据唯一主键
     */
    private Long id;

    /**
     *  数据版本
     *
     */
    private Integer version;

    /**
     * 数据状态
     *
     */
    private State state;

    /**
     *  创建时间
     *
     */
    private LocalDateTime createdTime;

    /**
     * 更新时间
     */
    private LocalDateTime updatedTime;



    public BaseTableEntity(){}
    public BaseTableEntity(boolean initial){
        if (initial){
            this.initial();
        }
    }

    public void initial() {
        version = 0;
        state = State.COMMON;
        createdTime = LocalDateTime.now();
        updatedTime = LocalDateTime.now();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public State getState() {
        return state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public LocalDateTime getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(LocalDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public LocalDateTime getUpdatedTime() {
        return updatedTime;
    }

    public void setUpdatedTime(LocalDateTime updatedTime) {
        this.updatedTime = updatedTime;
    }

}
