package cn.ipokerface.common.model.api;

import cn.ipokerface.common.model.BaseModel;

/**
 * Created by       PokerFace
 * Create Date      2020-11-03.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ResultBody<T> extends BaseModel{

    // code for success
    public static final int CODE_SUCCESS            = 10000;
    // code for error unknown
    public static final int CODE_ERROR              = 20000;
    // code for no resources
    public static final int CODE_NOT_FOUND          = 20001;
    // code for illegal request
    public static final int CODE_ILLEGAL            = 20002;
    // code for no access
    public static final int CODE_ACCESS             = 20010;
    // code for no authorization
    public static final int CODE_AUTHORIZATION      = 20020;

    /**
     * code status of this result response
     *
     */
    private int code;

    /**
     * message tips of this result response
     *
     */
    private String message;

    /**
     *  server response timestamp of response
     *
     */
    private Long timestamp;

    /**
     * response body of this response if response success
     *
     */
    private T body;


    /**
     *  constructor use
     *  {@link ResultBody#ResultBody(int, String, long, Object)}
     */
    public ResultBody(){
        this.code = CODE_SUCCESS;
        this.message = "SUCCESS";
    }

    /**
     *  Please use {@link #success(Object)} or {@link #error(int, String)}to build Response
     *
     * @param code response code
     * @param message  response message
     * @param timestamp response timestamp
     * @param body response body
     */
    private ResultBody(int code, String message, long timestamp, T body) {
        this.code = code;
        this.body = body;
        this.message = message;
        this.timestamp = timestamp;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public T getBody() {
        return body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public static <T> ResultBody<T> success(){
        return success(null);
    }

    public static <T> ResultBody<T> success(T data) {
        ResultBody<T> resultBody = new ResultBody<T>();
        resultBody.code = CODE_SUCCESS;
        resultBody.message = "SUCCESS";
        resultBody.timestamp = System.currentTimeMillis();
        resultBody.body = data;
        return resultBody;
    }


    public static ResultBody error(int code, String message) {
        ResultBody resultBody = new ResultBody();
        resultBody.code = code;
        resultBody.message = message;
        resultBody.timestamp = System.currentTimeMillis();
        return resultBody;
    }

    public static ResultBody error(String message) {
        return error(CODE_ERROR, message);
    }

    public static ResultBody error() {
        return error("ERROR");
    }






}
