package cn.ipokerface.common.model;

import org.apache.commons.collections4.CollectionUtils;

import java.util.List;
import java.util.function.Function;

/**
 * Created by       PokerFace
 * Create Date      2021/8/18
 * Version          1.0.0
 * Description:
 */
public class PaginationModel<T> extends BaseModel{

    // list data
    private List<T> list;

    // cursor
    private String cursor;


    public PaginationModel() {
    }


    /**
     *  paginationData of pagination size
     *
     * @param data data
     * @param cursor total
     */
    public PaginationModel(List<T> data, String cursor) {
        this.list = data;
        this.cursor = cursor;
    }


    /**
     * use at frontend.... pull refresh  and loadmore so on...
     *
     * @param data data
     * @param consumer cursor applier  return
     */
    public PaginationModel(List<T> data, CursorConsumer<T> consumer) {
        this.list = data;
        this.cursor = consumer.apply(CollectionUtils.isEmpty(data)?null:data.get(data.size()-1));
    }




    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }



    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }


    /**
     *  call this function to get last of this data to catch cursor
     *
     * @param <T> entity
     */
    public interface CursorConsumer<T> extends Function<T, String> {


        /**
         *
         *
         * @param data last data of this list
         * @return  cursor
         */
        String apply(T data);
    }
}
