package cn.ipokerface.common.fastjson.serilizer;

import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeSerializer implements ObjectSerializer {

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter serializerWriter = serializer.out;
        if (object == null) {
            serializerWriter.write("\"\"");
            return;
        }

        serializerWriter.write("\"");
        if (object instanceof LocalTime) {
            serializerWriter.write(DateTimeFormatter.ofPattern(LocalTimeUtils.fmt_time).format((LocalTime) object));
        }
        serializerWriter.write("\"");
    }
}
