package cn.ipokerface.common.fastjson.serilizer;

import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2021/8/18
 * Version          1.0.0
 * Description:
 *                  format Date LocaleDateTime to timestamp
 */
public class DateTimestampSerializer implements ObjectSerializer {


    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter serializerWriter = serializer.out;
        if (object == null) {
            serializerWriter.write("\"\"");
            return;
        }
        serializerWriter.write("\"");
        if (object instanceof LocalDateTime) {
            serializerWriter.write(String.valueOf(LocalTimeUtils.timestamp((LocalDateTime) object)));
        } else if (object instanceof Date) {
            serializerWriter.write(String.valueOf(((Date) object).getTime()));
        }
        serializerWriter.write("\"");
    }


}
