package cn.ipokerface.common.fastjson.serilizer;

import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2021/8/18
 * Version          1.0.0
 * Description:
 */
public class DateTimeFormatSerializer implements ObjectSerializer {

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter serializerWriter = serializer.out;
        if (object == null) {
            serializerWriter.write("\"\"");
            return;
        }

        serializerWriter.write("\"");
        if (object instanceof LocalDateTime) {
            serializerWriter.write(LocalTimeUtils.format((LocalDateTime) object, LocalTimeUtils.fmt_date_time));
        } else if (object instanceof Date) {
            serializerWriter.write(new SimpleDateFormat(LocalTimeUtils.fmt_date_time).format((Date) object));
        }
        serializerWriter.write("\"");
    }
}
