package cn.ipokerface.common.fastjson;

import cn.ipokerface.common.fastjson.filters.NullValueFilter;
import cn.ipokerface.common.fastjson.serilizer.DateTimestampSerializer;
import cn.ipokerface.common.fastjson.serilizer.LocalTimeSerializer;
import cn.ipokerface.common.fastjson.serilizer.LongSerializer;
import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public class Fastjson {

    static {
        SerializeConfig config = SerializeConfig.globalInstance;
        config.put(LocalDateTime.class, new DateTimestampSerializer());
        config.put(LocalTime.class, new LocalTimeSerializer());
        config.put(Long.class, new LongSerializer());
    }

    public static SerializeConfig serializeConfig() {
        return SerializeConfig.globalInstance;
    }

    public static SerializerFeature[] serializerFeatures() {
        return new SerializerFeature[]{
                SerializerFeature.PrettyFormat,
                SerializerFeature.WriteNullListAsEmpty,
                SerializerFeature.WriteNullStringAsEmpty,
                SerializerFeature.SkipTransientField,
                SerializerFeature.IgnoreNonFieldGetter,
                SerializerFeature.IgnoreErrorGetter,
                SerializerFeature.DisableCircularReferenceDetect,
                SerializerFeature.WriteDateUseDateFormat,
                SerializerFeature.WriteBigDecimalAsPlain,
                SerializerFeature.WriteNonStringKeyAsString
        };
    }

    public static SerializeFilter[] serializeFilters() {
        return new SerializeFilter[]{
                new NullValueFilter()
        };
    }


    public static String format(Object object){

        return JSON.toJSONString(object, SerializeConfig.globalInstance, serializeFilters(), LocalTimeUtils.fmt_date_time,JSON.DEFAULT_GENERATE_FEATURE, serializerFeatures());
    }





    public static <T> T parseObject(String ret, Class<T> clazz) {
        ParserConfig config = ParserConfig.global;

        Feature[] features = new Feature[]{

        };
        return JSON.parseObject(ret, clazz, config, null, JSON.DEFAULT_PARSER_FEATURE, features);
    }


    public static <T> List<T> parseArray(String ret, Class<T> clazz) {
        ParserConfig config = ParserConfig.global;
        return JSONArray.parseArray(ret, clazz, config);
    }

}
