package cn.ipokerface.common.exception;

import cn.ipokerface.common.model.api.ResultBody;

/**
 * Created by       PokerFace
 * Create Date      2021/8/10
 * Version          1.0.0
 * Description:
 */
public class ServiceResultException extends ServiceException{

    private ResultBody body;

    public ServiceResultException() {
        this(ResultBody.error());
    }
    public ServiceResultException(ResultBody body) {
        super(body.getMessage());
        this.body = body;
    }

    public ServiceResultException(int code, String message) {
        super(message);
        this.body = ResultBody.error(code, message);
    }

    public ServiceResultException(String message) {
        super(message);
        this.body = ResultBody.error( message);
    }


    public ResultBody getBody() {
        return body;
    }

    public void setBody(ResultBody body) {
        this.body = body;
    }
}
