package cn.ipokerface.common.digest;

import cn.ipokerface.common.utils.RSADigestUtils;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

/**
 * Created by       PokerFace
 * Create Date      2020-08-20.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class RsaEncrypt {

    private String privateKey;

    private String publicKey;

    public RsaEncrypt(String privateKey, String publicKey)
    {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public String getPublicKey() {
        return publicKey;
    }


    /**
     *  服务端数据加密
     *
     * @param source data to encrypt
     * @return value encrypted
     * @throws NoSuchAlgorithmException NoSuchAlgorithmException
     * @throws NoSuchPaddingException NoSuchPaddingException
     * @throws InvalidKeyException InvalidKeyException
     * @throws InvalidKeySpecException InvalidKeySpecException
     * @throws BadPaddingException BadPaddingException
     * @throws IllegalBlockSizeException IllegalBlockSizeException
     */
    public String encrypt(String source) throws NoSuchAlgorithmException, NoSuchPaddingException,
            InvalidKeyException, InvalidKeySpecException, BadPaddingException, IllegalBlockSizeException
    {
        return RSADigestUtils.encipher(source, publicKey);
    }


    /**
     *  数据解密
     *
     * @param crypt crypted value to decode
     * @return decoded data
     * @throws NoSuchAlgorithmException NoSuchAlgorithmException
     * @throws NoSuchPaddingException NoSuchPaddingException
     * @throws InvalidKeyException InvalidKeyException
     * @throws InvalidKeySpecException InvalidKeySpecException
     * @throws BadPaddingException BadPaddingException
     * @throws IllegalBlockSizeException IllegalBlockSizeException
     * @throws IOException  IOException
     */
    public String decrypt(String crypt) throws NoSuchAlgorithmException, NoSuchPaddingException,
            InvalidKeyException, InvalidKeySpecException, BadPaddingException, IllegalBlockSizeException, IOException
    {
        return RSADigestUtils.decipher(crypt, privateKey);
    }
}
