package cn.ipokerface.common.digest;

import cn.ipokerface.common.utils.StringUtils;

/**
 * Created by       PokerFace
 * Create Date      2021/6/9.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class FakeEncrypt {

    private byte[] encrypt_salt = new byte[32];
    private byte[] decrypt_salt = new byte[]{
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
    };



    /**
     * 传入一个 32位字符串数组，字符不能重复 最好不使用url特殊字符
     *
     * @param salt salt data
     */
    public FakeEncrypt(String salt)
    {
        if (StringUtils.isEmpty(salt) || salt.length() != 32)
            throw new IllegalArgumentException("Salt should be 16 bytes of data");

        encrypt_salt = salt.getBytes();

        for (byte i=0; i< encrypt_salt.length; i++){
            byte b = encrypt_salt[i];
            decrypt_salt[b] = i;
        }
    }


    /**
     * 对数据进行Base64加密 ,返回加密后的数据
     *
     * @param bytes 需要加密的数据
     * @return 加密处理后的字符串
     */
    public byte[] encode(byte[] bytes) {
        int length = bytes.length;
        int groupCount = length / 5;
        int paddingBytes = length % 5;
        int resultLen = 8 * groupCount + (paddingBytes == 0 ?0:
                (paddingBytes == 1?2:
                        (paddingBytes == 2?4:(
                                paddingBytes == 3?5:7))));
        byte[] result = new byte[resultLen];
        int resultIndex = 0;
        // Translate all full groups from byte array elements to Base64
        int in = 0;
        for (int i = 0; i < groupCount; i++) {
            int byte0 = bytes[in++] & 0xff;
            int byte1 = bytes[in++] & 0xff;
            int byte2 = bytes[in++] & 0xff;
            int byte3 = bytes[in++] & 0xff;
            int byte4 = bytes[in++] & 0xff;
            // 取第一个字节的前5位
            result[resultIndex ++] = encrypt_salt[byte0 >> 3 & 0x1f];
            // 取第一个字节的后3位与第二字节的前2位
            result[resultIndex ++] = (encrypt_salt[(byte0 << 2) & 0x1f | (byte1 >> 6)]);
            // 取第二个字节的第3位到第七位
            result[resultIndex ++] = (encrypt_salt[(byte1 >> 1) & 0x1f]);
            // 取第二个字节的第8位与第三个字节的前4位
            result[resultIndex ++] = (encrypt_salt[(byte1 << 4) & 0x1f | (byte2 >> 4)]);
            // 取第三个字节的后4位与第四个字节的前1位
            result[resultIndex ++] = (encrypt_salt[(byte2 << 1) & 0x1f | (byte3 >> 7)]);
            // 取第四个字节的第2位到第6位
            result[resultIndex ++] = (encrypt_salt[(byte3 >> 2) & 0x1f]);
            // 取第四个字节的后两位与第五个字节的前三位
            result[resultIndex ++] = (encrypt_salt[(byte3 << 3) & 0x1f | (byte4 >> 5)]);
            // 取第五个字节的后5位
            result[resultIndex ++] = (encrypt_salt[byte4 & 0x1f]);
        }

        if (paddingBytes == 1) {
            // 整个结果的长度应该是 8n+2
            int byte0 = bytes[in++] & 0xff;
            // 取第一个字节的前5位
            result[resultIndex ++] = encrypt_salt[byte0 >> 3 & 0x1f];
            result[resultIndex ++] = (encrypt_salt[(byte0 << 2) & 0x1f]);
        }
        else if (paddingBytes == 2) {
            // 整个结果的长度应该是 8n+4
            int byte0 = bytes[in++] & 0xff;
            int byte1 = bytes[in++] & 0xff;
            // 取第一个字节的前5位
            result[resultIndex ++] = encrypt_salt[byte0 >> 3 & 0x1f];
            // 取第一个字节的后3位与第二字节的前2位
            result[resultIndex ++] = (encrypt_salt[(byte0 << 2) & 0x1f | (byte1 >> 6)]);
            // 取第二个字节的第3位到第七位
            result[resultIndex ++] = (encrypt_salt[(byte1 >> 1) & 0x1f]);
            // 取第二个字节的第8位
            result[resultIndex ++] = (encrypt_salt[(byte1 << 4) & 0x1f]);
        }
        else if (paddingBytes == 3) {
            // 整个结果的长度应该是 8n+5
            int byte0 = bytes[in++] & 0xff;
            int byte1 = bytes[in++] & 0xff;
            int byte2 = bytes[in++] & 0xff;
            // 取第一个字节的前5位
            result[resultIndex ++] = encrypt_salt[byte0 >> 3 & 0x1f];
            // 取第一个字节的后3位与第二字节的前2位
            result[resultIndex ++] = (encrypt_salt[(byte0 << 2) & 0x1f | (byte1 >> 6)]);
            // 取第二个字节的第3位到第七位
            result[resultIndex ++] = (encrypt_salt[(byte1 >> 1) & 0x1f]);
            // 取第二个字节的第8位与第三个字节的前4位
            result[resultIndex ++] = (encrypt_salt[(byte1 << 4) & 0x1f | (byte2 >> 4)]);
            // 取第三个字节的后4位
            result[resultIndex ++] = (encrypt_salt[(byte2 << 1) & 0x1f]);
        }else if (paddingBytes == 4) {
            // 整个结果的长度应该是 8n+7
            int byte0 = bytes[in++] & 0xff;
            int byte1 = bytes[in++] & 0xff;
            int byte2 = bytes[in++] & 0xff;
            int byte3 = bytes[in++] & 0xff;
            // 取第一个字节的前5位
            result[resultIndex ++] = encrypt_salt[byte0 >> 3 & 0x1f];
            // 取第一个字节的后3位与第二字节的前2位
            result[resultIndex ++] = (encrypt_salt[(byte0 << 2) & 0x1f | (byte1 >> 6)]);
            // 取第二个字节的第3位到第七位
            result[resultIndex ++] = (encrypt_salt[(byte1 >> 1) & 0x1f]);
            // 取第二个字节的第8位与第三个字节的前4位
            result[resultIndex ++] = (encrypt_salt[(byte1 << 4) & 0x1f | (byte2 >> 4)]);
            // 取第三个字节的后4位与第四个字节的前1位
            result[resultIndex ++] = (encrypt_salt[(byte2 << 1) & 0x1f | (byte3 >> 7)]);
            // 取第四个字节的第2位到第6位
            result[resultIndex ++] = (encrypt_salt[(byte3 >> 2) & 0x1f]);
            // 取第四个字节的后两位
            result[resultIndex ++] = (encrypt_salt[(byte3 << 3) & 0x1f]);
        }

        return result;
    }


    public String encodeString(String data) {
        return new String(encode(data.getBytes()));
    }

    /**
     * 对由Base64加密处理后的数据进行解密
     *
     * @param data 需要解密运算的字符串
     * @return 解密过后的字符串
     */
    public byte[] decode(byte[] data) {

        if (data == null) {
            throw new IllegalArgumentException("String length must have value");
        }
        int groupCount = data.length / 8;
        int paddingCount = data.length % 8;

        // 原字符串多出来的字符数
        int missingBytes = paddingCount == 0 ?0:(
                paddingCount == 2? 1:(
                        paddingCount == 4?2:(
                                paddingCount == 5?3:4)));

        byte[] result = new byte[groupCount * 5 + missingBytes];
        int in = 0, out = 0;
        for (int i = 0; i < groupCount; i++) {
            // 如果有补全字符并且循环到最后一组加密数据
            byte ch0 = decrypt_salt[data[in++]];
            byte ch1 = decrypt_salt[data[in++]];
            byte ch2 = decrypt_salt[data[in++]];
            byte ch3 = decrypt_salt[data[in++]];
            byte ch4 = decrypt_salt[data[in++]];
            byte ch5 = decrypt_salt[data[in++]];
            byte ch6 = decrypt_salt[data[in++]];
            byte ch7 = decrypt_salt[data[in++]];
            result[out++] = (byte) ((ch0 << 3) | (ch1 >> 2));
            result[out++] = (byte) ((ch1 << 6) | (ch2 << 1) | (ch3 >> 4));
            result[out++] = (byte) ((ch3 << 4) | (ch4 >> 1));
            result[out++] = (byte) ((ch4 << 7) | (ch5 << 2) | (ch6 >> 3));
            result[out++] = (byte) ((ch6 << 5) | ch7);
        }
        if (missingBytes == 1) {
            byte ch0 = decrypt_salt[data[in++]];
            byte ch1 = decrypt_salt[data[in++]];
            result[out++] = (byte) ((ch0 << 3) | (ch1 >> 2));
        } else if (missingBytes == 2) {
            byte ch0 = decrypt_salt[data[in++]];
            byte ch1 = decrypt_salt[data[in++]];
            byte ch2 = decrypt_salt[data[in++]];
            byte ch3 = decrypt_salt[data[in++]];
            result[out++] = (byte) ((ch0 << 3) | (ch1 >> 2));
            result[out++] = (byte) ((ch1 << 6) | (ch2 << 1) | (ch3 >> 4));
        } else if (missingBytes == 3) {
            // 如果有补全字符并且循环到最后一组加密数据
            byte ch0 = decrypt_salt[data[in++]];
            byte ch1 = decrypt_salt[data[in++]];
            byte ch2 = decrypt_salt[data[in++]];
            byte ch3 = decrypt_salt[data[in++]];
            byte ch4 = decrypt_salt[data[in++]];

            result[out++] = (byte) ((ch0 << 3) | (ch1 >> 2));
            result[out++] = (byte) ((ch1 << 6) | (ch2 << 1) | (ch3 >> 4));
            result[out++] = (byte) ((ch3 << 4) | (ch4 >> 1));
        } else if (missingBytes == 4) {
            byte ch0 = decrypt_salt[data[in++]];
            byte ch1 = decrypt_salt[data[in++]];
            byte ch2 = decrypt_salt[data[in++]];
            byte ch3 = decrypt_salt[data[in++]];
            byte ch4 = decrypt_salt[data[in++]];
            byte ch5 = decrypt_salt[data[in++]];
            byte ch6 = decrypt_salt[data[in++]];
            result[out++] = (byte) ((ch0 << 3) | (ch1 >> 2));
            result[out++] = (byte) ((ch1 << 6) | (ch2 << 1) | (ch3 >> 4));
            result[out++] = (byte) ((ch3 << 4) | (ch4 >> 1));
            result[out++] = (byte) ((ch4 << 7) | (ch5 << 2) | (ch6 >> 3));
        }
        return result;
    }


    public String decodeString(String str)
    {
        return new String(decode(str.getBytes()));
    }

}
