package cn.ipokerface.common.digest;

import cn.ipokerface.common.utils.StringUtils;

/**
 * Created by       PokerFace
 * Create Date      2020-08-20.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class Base64Encrypt {



    private byte[] encrypt_salt = new byte[64];
    private byte[] decrypt_salt = new byte[]{
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
            -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
    };

    private byte padding;


    /**
     * 传入一个 64位字符串数组，字符不能重复 最好不使用url特殊字符
     *
     * @param salt salt data
     * @param padding padding
     */
    public Base64Encrypt(String salt, byte padding)
    {
        if (StringUtils.isEmpty(salt) || salt.length() != 64)
            throw new IllegalArgumentException("Salt should be 64 bytes of data");

        encrypt_salt = salt.getBytes();
        this.padding = padding;

        for (byte i=0; i< encrypt_salt.length; i++){
            byte b = encrypt_salt[i];
            decrypt_salt[b] = i;
        }


    }



    /**
     * 对数据进行Base64加密 ,返回加密后的数据
     *
     * @param bytes 需要加密的数据
     * @return 加密处理后的字符串
     */
    public byte[] encode(byte[] bytes) {
        int length = bytes.length;
        int groupCount = length / 3;
        int paddingBytes = length % 3;
        int paddingLength = length - paddingBytes;

        int resultLen = 4 * ((length + 2) / 3);
        byte[] result = new byte[resultLen];
        int resultIndex = 0;
        // Translate all full groups from byte array elements to Base64
        int in = 0;
        for (int i = 0; i < groupCount; i++) {
            int byte0 = bytes[in++] & 0xff;
            int byte1 = bytes[in++] & 0xff;
            int byte2 = bytes[in++] & 0xff;
            // 取第一个字节的前6位
            result[resultIndex ++] = encrypt_salt[byte0 >> 2 ];
            // 取第一个字节的后2位与第二字节的前4位
            result[resultIndex ++] = (encrypt_salt[(byte0 << 4) & 0x3f | (byte1 >> 4)]);
            // 取第二个字节的的后四位与第三个字节的前2位
            result[resultIndex ++] = (encrypt_salt[(byte1 << 2) & 0x3f | (byte2 >> 6)]);
            // 取第三个字节的后6位
            result[resultIndex ++] = (encrypt_salt[byte2 & 0x3f]);
        }

        // 多出一个字节时
        if (paddingBytes == 1) {
            int byte0 = bytes[in++] & 0xff;
            // 取第一个字节的前6位
            result[resultIndex ++] = (encrypt_salt[byte0 >> 2 & 0x3f]);
            result[resultIndex ++] = (encrypt_salt[(byte0 << 4) & 0x3f]);
            result[resultIndex ++] = (padding);
            result[resultIndex ++] = (padding);
        }
        // 多出两个字节时
        if (paddingBytes == 2) {
            result[resultIndex ++] = (encrypt_salt[(bytes[paddingLength] & 0xff) >> 2 & 0x3f]);
            result[resultIndex ++] = (encrypt_salt[((bytes[paddingLength] & 0xff) << 4) & 0x3f | ((bytes[paddingLength + 1] & 0xff) >> 4) & 0x3f]);
            result[resultIndex ++] = (encrypt_salt[(bytes[paddingLength + 1] << 2) & 0x3f]);
            result[resultIndex ++] = (padding);
        }
        return result;
    }


    /**
     *  加密字符串
     *
     * @param data  data to encrypt
     * @return encrypted data
     */
    public byte[] encode(String data){
        return encode(data.getBytes());
    }

    /**
     * 加密成字符串
     *
     * @param str str data to encrypt
     * @return encrypted data
     */
    public String encodeString(String str)
    {
        return new String(encode(str.getBytes()));
    }



    /**
     * 对由Base64加密处理后的数据进行解密
     *
     * @param data 需要解密运算的字符串
     * @return 解密过后的字符串
     */
    public byte[] decode(byte[] data) {

        if (data == null || data.length % 4 != 0) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int groupCount = data.length / 4;

        int missingBytes = 0;
        if (data.length != 0) {
            if (data[data.length - 1] == padding) {
                missingBytes++;
                if ( data[data.length - 2] == padding) {
                    missingBytes++;
                }
            }
        }
        byte[] result = new byte[groupCount * 3 - missingBytes];
        int in = 0, out = 0;
        for (int i = 0; i < groupCount; i++) {
            // 如果有补全字符并且循环到最后一组加密数据
            if (i == groupCount - 1 && missingBytes > 0) {
                byte ch0 = decrypt_salt[data[in++]];
                byte ch1 = decrypt_salt[data[in++]];
                result[out++] = (byte) ((ch0 << 2) | (ch1 >> 4));

                if (missingBytes == 1) {
                    byte ch2 = decrypt_salt[data[in++]];
                    result[out++] = (byte) ((ch1 << 4) | (ch2 >> 2));
                }
            } else {
                byte ch0 = decrypt_salt[data[in++]];
                byte ch1 = decrypt_salt[data[in++]];
                byte ch2 = decrypt_salt[data[in++]];
                byte ch3 = decrypt_salt[data[in++]];
                result[out++] = (byte) ((ch0 << 2) | (ch1 >> 4));
                result[out++] = (byte) ((ch1 << 4) | (ch2 >> 2));
                result[out++] = (byte) ((ch2 << 6) | ch3);
            }
        }
        return result;
    }

    /**
     *  解密字符串
     *
     * @param str str to be decode
     * @return decode hex string
     */
    public byte[] decode(String str){
        return decode(str.getBytes());
    }


    /**
     *  解密成字符串
     *
     * @param str   value to decode
     * @return  decoded value
     */
    public String decodeString(String str)
    {
        return new String(decode(str.getBytes()));
    }

}
