/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    public static String fileExt(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        if (filename.indexOf(".") < 0) {
            return null;
        }
        return filename.substring(filename.lastIndexOf(".") + 1, filename.length());
    }

    public static String folderWithSlash(String folderName) {
        if (StringUtils.isEmpty((CharSequence)folderName)) {
            return null;
        }
        if (folderName.endsWith("/")) {
            return folderName;
        }
        return folderName + "/";
    }

    public static boolean isImage(String contentType) {
        return !StringUtils.isEmpty((CharSequence)contentType) && contentType.startsWith("image");
    }

    public static void copyFile(File source, File target, boolean override) throws IOException {
        if (source == null || !source.exists()) {
            return;
        }
        if (target.exists()) {
            if (override) {
                target.delete();
            } else {
                return;
            }
        }
        FileUtils.writeTo(new FileInputStream(source), (OutputStream)new FileOutputStream(target));
    }

    public static void writeTo(String file, OutputStream outputStream) throws IOException {
        FileUtils.writeTo(new File(file), outputStream);
    }

    public static void writeTo(File file, OutputStream outputStream) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        FileUtils.writeTo(new FileInputStream(file), outputStream);
    }

    public static void writeTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int b;
        byte[] buffer = new byte[1024];
        while ((b = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, b);
        }
        outputStream.flush();
    }
}

