/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.model.api;

import cn.ipokerface.common.model.BaseModel;

public class ResultBody
extends BaseModel {
    private int code;
    private String message;
    private Long timestamp;
    private BaseModel body;

    private ResultBody() {
    }

    private ResultBody(int code, String message, long timestamp, BaseModel body) {
        this.code = code;
        this.body = body;
        this.message = message;
        this.timestamp = timestamp;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public BaseModel getBody() {
        return this.body;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Result {
        SUCCESS(10000, "success"),
        ERROR(20000, "error"),
        ERROR_NOT_FOUND(20001, "Resource not found"),
        ERROR_METHOD(20002, "Invalid request method"),
        ERROR_ARGUMENT(20003, "Argument error"),
        ERROR_DATA(20004, "Data error"),
        ERROR_SIGNATURE(20005, "Signature wrong"),
        ERROR_LENGTH(20006, "Request over length"),
        ERROR_ACCESS(30000, "No access"),
        ERROR_AUTHORITY(30001, "No authority");

        private final int code;
        private final String msg;

        private Result(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            return "Result{code=" + this.code + ", msg='" + this.msg + '\'' + '}';
        }
    }

    public static class Builder {
        private int code = Result.SUCCESS.getCode();
        private String message = Result.SUCCESS.getMsg();
        private BaseModel data;

        public Builder data(BaseModel obj) {
            this.data = obj;
            return this;
        }

        public Builder error() {
            return this.error(Result.ERROR.getMsg());
        }

        public Builder error(int code) {
            return this.error(code, Result.ERROR.getMsg());
        }

        public Builder error(String message) {
            return this.error(Result.ERROR.code, message);
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder error(int code, String message) {
            this.code = code;
            this.message = message;
            return this;
        }

        public ResultBody build() {
            return new ResultBody(this.code, this.message, System.currentTimeMillis(), this.data == null ? null : this.data);
        }
    }
}

