/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RSADigestUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String ENCRYPT_TYPE = "RSA";

    public static RSAKeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ENCRYPT_TYPE);
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        String privateKeyString = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        RSAKeyPair pair = new RSAKeyPair(privateKeyString, publicKeyString);
        return pair;
    }

    public static String encrypt(String str, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] decoded = Base64.decodeBase64((String)publicKey);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance(ENCRYPT_TYPE).generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance(ENCRYPT_TYPE);
        cipher.init(1, pubKey);
        String outStr = Base64.encodeBase64String((byte[])cipher.doFinal(str.getBytes()));
        return outStr;
    }

    public static String decrypt(String str, String privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, BadPaddingException, IllegalBlockSizeException {
        byte[] inputByte = Base64.decodeBase64((byte[])str.getBytes());
        byte[] decoded = Base64.decodeBase64((String)privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance(ENCRYPT_TYPE).generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance(ENCRYPT_TYPE);
        cipher.init(2, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }

    public static class RSAKeyPair {
        private String privateKey;
        private String publicKey;

        public RSAKeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }
    }
}

